const tutorialButton = document.getElementById('tutorialButton');
const tutorialButton0 = document.getElementById('tutorialButton0');
const tutorialButton1 = document.getElementById('tutorialButton1');
const tutorialButton2 = document.getElementById('tutorialButton2');
const tutorialButton3 = document.getElementById('tutorialButton3');
// const // tutorialButton4 = document.getElementById('// tutorialButton4');
const tutorialWindow = document.getElementById('tutorialWindow');
const tutorialText = document.getElementById('tutorialText');
let tutorialIndex = 0;
let tutorialInterval;

// チュートリアルのテキスト内容
const tutorialSteps = [
    "JavaScript Editor v2-IA をご利用いただき、ありがとうございます。\n（本チュートリアルは10秒毎にテキストが変わります。）",
    "それでは本エディターのチュートリアルを開始します。",
    "チュートリアル. \n まずはイベントエディタの方へマウスカーソルを移動させてください。",
    "チュートリアル. \n ここでメインとなるプログラムを組みます。\n\n 変数、関数、反復処理、条件分岐、HTMLの操作など簡素ながら柔軟性のある仕様となっています。",
    "チュートリアル. \n 設置したコマンドは選択すると、ドラッグ・アンド・ドロップで移動したり、選択してから右クリックを押すと、選択したコマンドのコピーや切り取り、貼り付けができます。",
    "チュートリアル. \n 配置したい位置の上にあるコマンドを選択して貼り付けを押すと、その選択したコマンドの下にコピーまたは切り取ったコマンドが貼付けされます。",
    "チュートリアル. \n ドラッグ・アンド・ドロップも同様ですが、条件分岐やループ、関数の上にドロップをすると、条件分岐、ループ、関数の中にコマンドが移動します。",
    "チュートリアル. \n 次に、右の「生成コード」というウィンドウの方へ移動してください。",
    "チュートリアル. \n ここには組んだプログラムが自動的に JavaScriptに変換されて出力されます。",
    "チュートリアル. \n コピーのボタンを押すと、生成されたコードをコピーできます。",
    "チュートリアル. \n イベントエディタで組んだプログラムは、基本的に自動的でJavaScriptに変換されますが、場合によっては処理されないこともあります。\n\n そんなときは、「コード生成」というボタンを押してください。",
    "チュートリアル. \n ヘッダー付近にあるゲージバーに注目してください。",
    "チュートリアル. \n これは コード変換の処理進捗を表すものです。\nゲージがいっぱいになるとコードを出力します。",
    "チュートリアル. \n 最後に「HTMLインポート」についてです。",
    "チュートリアル. \n コマンドを組む上で、DOM操作（HTMLの操作）が可能と説明しました。\n javascriptでHTMLを操作する際、「id名」というタグを使って、どのHTMLタグを操作するのか選択します。",
    "チュートリアル. \n この「HTMLインポート」は、ソースコードを貼り付け、または、ファイルをインポートすることで、自動的にHTML内のidタグを識別し、要素に付けたid名を手動で入力しなくても、選択するだけで、操作したいHTMLタグを指定できます。",
    "以上が本アプリのUI説明です。 \n produced by Daido-h ICT - programming club",
];

// マウス追跡（画面内に制限）
document.addEventListener('mousemove', (e) => {
    const windowWidth = window.innerWidth;
    const windowHeight = window.innerHeight;
    const windowRect = tutorialWindow.getBoundingClientRect();
    const windowWidthPx = windowRect.width;
    const windowHeightPx = windowRect.height;

    let x = e.clientX + 20;
    let y = e.clientY + 20;

    if (x + windowWidthPx > windowWidth) {
        x = windowWidth - windowWidthPx - 5;
    }
    if (x < 0) {
        x = 5;
    }
    if (y + windowHeightPx > windowHeight) {
        y = windowHeight - windowHeightPx - 5;
    }
    if (y < 0) {
        y = 5;
    }

    tutorialWindow.style.left = `${x}px`;
    tutorialWindow.style.top = `${y}px`;
});

// タイピングアニメーション
function typeText(text, callback) {
    tutorialText.textContent = '';
    tutorialText.classList.add('typing');
    let i = 0;

    function type() {
        if (i < text.length) {
            tutorialText.textContent += text.charAt(i);
            i++;
            setTimeout(type, 25); // 1文字ごとの表示速度（ミリ秒）
        } else {
            tutorialText.classList.remove('typing');
            if (callback) callback();
        }
    }
    type();
}

// チュートリアル開始
tutorialButton.addEventListener('click', () => {
    tutorialButton.style.display = 'none';
    tutorialButton0.style.display = 'none';
    tutorialButton1.style.display = 'none';
    tutorialButton2.style.display = 'none';
    tutorialButton3.style.display = 'none';
    // // tutorialButton4.style.display = 'none';
    tutorialWindow.style.display = 'block';
    tutorialIndex = 0;
    typeText(tutorialSteps[tutorialIndex], startTutorialInterval);
});

// 15秒ごとのテキスト切り替え
function startTutorialInterval() {
    tutorialInterval = setInterval(() => {
        tutorialIndex++;
        if (tutorialIndex < tutorialSteps.length) {
            typeText(tutorialSteps[tutorialIndex], () => {
                if (tutorialIndex === tutorialSteps.length - 1) {
                    setTimeout(() => {
                        clearInterval(tutorialInterval);
                        tutorialWindow.style.display = 'none';
                        tutorialButton.style.display = 'block';
                        tutorialButton0.style.display = 'block';
                        tutorialButton1.style.display = 'block';
                        tutorialButton2.style.display = 'block';
                        tutorialButton3.style.display = 'block';
                        // tutorialButton4.style.display = 'block';
                    }, 10000); // 最後のテキスト表示後に15秒待つ
                }
            });
        } else {
            clearInterval(tutorialInterval);
            tutorialWindow.style.display = 'none';
            tutorialButton.style.display = 'block';
            tutorialButton0.style.display = 'block';
            tutorialButton1.style.display = 'block';
            tutorialButton2.style.display = 'block';
            tutorialButton3.style.display = 'block';
            // tutorialButton4.style.display = 'block';
        }
    }, 10000);
}