var inputText = document.getElementById("input-text");
var inputButton = document.getElementById("input-button");

inputButton.addEventListener("click", function() {
  var message = inputText.value;
  if (message) {
    showUserMessage(message);
    var responses = generateResponses(message);
    for (var i = 0; i < responses.length; i++) {
      showBotMessage(responses[i]);
    }
    inputText.value = "";
  }
});

function showUserMessage(message) {
  var userMessage = document.createElement("div");
  userMessage.className = "user-message";
  userMessage.textContent = message;
  var container = document.querySelector(".container");
  container.appendChild(userMessage);
  container.scrollTop = container.scrollHeight;
}

function showBotMessage(message) {
  var botMessage = document.createElement("div");
  botMessage.className = "bot-message";
  botMessage.textContent = message;
  var container = document.querySelector(".container");
  container.appendChild(botMessage);
  container.scrollTop = container.scrollHeight;
}

function generateResponses(message) {
  var responses = [];
  if (message.includes("こんにち")) {
    responses.push("こんにちは、リラです。");
  } else if (message.includes("こんばん")) {
    responses.push("こんばんは、リラです。");
  } else if (message.includes("おはよう")) {
    responses.push("おはようございます、リラです。");

  } else { 
   responses.push("すみません、変数が存在しないため、その質問に対する回答を作成できません。漢字変換できる箇所はすべて変換して、もう一度試みてください。");
  }
  return responses;
}
