const scenes = [
    {
        background: './img/background',
        leftCharacter: 'character1.png',
        rightCharacter: 'character2.png',
        text: '最初のシーン',
        choices: [
            { text: '次のシーン', nextScene: 1 },
            { text: '次の次のシーン', nextScene: 2 }
        ]
    },
    {
        background: './img/background',
        leftCharacter: 'character3.png',
        rightCharacter: 'character4.png',
        text: 'これは2番目のシーンです。',
        choices: []
    },
    {
        background: 'background3.jpg',
        leftCharacter: 'character5.png',
        rightCharacter: 'character6.png',
        text: 'これは3番目のシーンです。',
        choices: []
    }
];

let currentScene = 0;

function loadScene(sceneIndex) {
    const scene = scenes[sceneIndex];
    document.getElementById('background').style.backgroundImage = `url(${scene.background})`;
    document.getElementById('left-character').style.backgroundImage = `url(${scene.leftCharacter})`;
    document.getElementById('right-character').style.backgroundImage = `url(${scene.rightCharacter})`;
    document.getElementById('text').innerText = scene.text;

    const choicesContainer = document.getElementById('choices');
    choicesContainer.innerHTML = '';
    scene.choices.forEach(choice => {
        const choiceElement = document.createElement('div');
        choiceElement.className = 'choice';
        choiceElement.innerText = choice.text;
        choiceElement.onclick = () => loadScene(choice.nextScene);
        choicesContainer.appendChild(choiceElement);
    });
}

window.onload = () => {
    loadScene(currentScene);
};
