document.getElementById('start-button').addEventListener('click', startGame);

let currentBGM = '';
let bgmPosition = 0;

function startGame() {
    document.getElementById('title-screen').style.display = 'none';
    document.getElementById('game-screen').style.display = 'block';
    showScene(0);
}

const scenes = [
    {
        background: './img/background/',
        leftCharacter: 'character1.png',
        rightCharacter: 'character2.png',
        dialogue: 'これは最初のシーンです。',
        bgm: './bgm/',
        choices: [
            { text: '選択肢1', nextScene: 1 },
            { text: '選択肢2', nextScene: 2 }
        ]
    },
    {
        background: './img/background/',
        leftCharacter: 'character1.png',
        rightCharacter: 'character2.png',
        dialogue: 'これは最初のシーンです。',
        bgm: './bgm/',
        choices: [
            { text: '選択肢2', nextScene: 2 }
        ]
    },
    {
        background: './img/background/',
        leftCharacter: 'character1.png',
        rightCharacter: 'character2.png',
        dialogue: 'これは最初のシーンです。',
        bgm: './bgm/',
        choices: []
    }
];

function showScene(index) {
    const scene = scenes[index];
    document.getElementById('background').style.backgroundImage = `url(${scene.background})`;
    document.getElementById('left-character').style.backgroundImage = `url(${scene.leftCharacter})`;
    document.getElementById('right-character').style.backgroundImage = `url(${scene.rightCharacter})`;
    changeBGM(scene.bgm);
    typeDialogue(scene.dialogue, () => {
        if (scene.choices.length > 0) {
            showChoices(scene.choices);
        }
    });
}

function changeBGM(bgm) {
    const bgmElement = document.getElementById('bgm');
    if (bgm === currentBGM) {
        bgmElement.currentTime = bgmPosition;
    } else {
        bgmElement.src = bgm;
        bgmElement.play();
        currentBGM = bgm;
        bgmPosition = 0;
    }
    bgmElement.play();
}

document.getElementById('bgm').addEventListener('timeupdate', () => {
    bgmPosition = document.getElementById('bgm').currentTime;
});

function typeDialogue(text, callback) {
    const dialogueText = document.getElementById('dialogue-text');
    dialogueText.textContent = '';
    let i = 0;
    const typingSpeed = 50;
    const interval = setInterval(() => {
        if (i < text.length) {
            dialogueText.textContent += text.charAt(i);
            i++;
        } else {
            clearInterval(interval);
            setTimeout(callback, 10000);
        }
    }, typingSpeed);
}

function showChoices(choices) {
    const choicesContainer = document.getElementById('choices');
    choicesContainer.style.display = 'block';
    choicesContainer.innerHTML = '';
    choices.forEach(choice => {
        const button = document.createElement('button');
        button.className = 'choice-button';
        button.textContent = choice.text;
        button.addEventListener('click', () => {
            choicesContainer.style.display = 'none';
            showScene(choice.nextScene);
        });
        choicesContainer.appendChild(button);
    });
}
