
  
        // 広告ブロック検出関数
        function detectAdBlock() {
            console.log("広告ブロック検出を開始します...");

            // 方法1: ダミー広告要素のチェック
            const ad = document.getElementById('adElement');
            let isBlocked = false;

            if (!ad) {
                console.log("ダミー広告要素が見つかりません。");
                isBlocked = true;
            } else {
                const style = window.getComputedStyle(ad);
                const isHidden = style.display === 'none' || style.visibility === 'hidden' || ad.offsetHeight === 0;
                console.log("ダミー広告の状態: ", {
                    display: style.display,
                    visibility: style.visibility,
                    offsetHeight: ad.offsetHeight
                });
                if (isHidden) {
                    isBlocked = true;
                }
            }

            // 方法2: 広告スクリプトの読み込みを試みる（オプション）
            const testAdScript = document.createElement('script');
            testAdScript.src = 'https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js';
            testAdScript.async = true;
            testAdScript.onerror = function() {
                console.log("広告スクリプトの読み込みに失敗しました。広告ブロックが有効の可能性があります。");
                isBlocked = true;
                showOverlay();
            };
            testAdScript.onload = function() {
                console.log("広告スクリプトが読み込まれました。広告ブロックは無効の可能性があります。");
            };
            document.head.appendChild(testAdScript);

            // 広告ブロックが検出された場合、オーバーレイを表示
            if (isBlocked) {
                showOverlay();
            }

            function showOverlay() {
                console.log("広告ブロックが検出されました。オーバーレイを表示します。");
                document.getElementById('adblockOverlay').style.display = 'flex';
            }
        }

        // 警告を閉じる関数
        function closeOverlay() {
            console.log("警告オーバーレイを閉じます。");
            document.getElementById('adblockOverlay').style.display = 'none';
            setTimeout(detectAdBlock, 10000);
        }

        // ページ読み込み後に検出を実行（遅延を長めに設定）
        window.addEventListener('load', function() {
            console.log("ページ読み込み完了。検出を1秒後に実行します。");
            setTimeout(detectAdBlock, 1000); // 1秒遅延で広告ブロッカーの処理を待つ
        });